#!/usr/bin/python
#Usage tail -f file | py-colorizer

import sys

colorCode = {
    "black" : "\033[30m",
    "blue" : "\033[34m",
    "green" : "\033[32m",
    "cyan" : "\033[36m",
    "red" : "\033[31m",
    "purple" : "\033[35m",
    "yellow" : "\033[33m",
    "white" : "\033[37m",
    "bold-red" : "\033[1;31m",
}

sys.stdout.write (colorCode["white"])

# read line by line from standard input
while 1:
    try:
	next = sys.stdin.readline()         # read a one-line string
	if not next:                        # or an empty string at EOF
	    break

	parts = next.split()
	
	# simple check
	if len(parts) > 2:
	    if parts[2] == "INFO":
		sys.stdout.write (colorCode["white"])
	    elif parts[2] == "DEBUG":
		sys.stdout.write (colorCode["cyan"])
	    elif parts[2] == "WARN":
		sys.stdout.write (colorCode["yellow"])
	    elif parts[2] == "ERROR":
		sys.stdout.write (colorCode["red"])
	    elif parts[2] == "SEVERE":
		sys.stdout.write (colorCode["red"])
	    elif parts[2] == "FATAL":
		sys.stdout.write (colorCode["bold-red"])
	    elif parts[2] == "CONFIG":
		sys.stdout.write (colorCode["purple"])
	    
	sys.stdout.write (next)

    except KeyboardInterrupt:
	break

sys.stdout.write (colorCode["white"])

